#pragma GCC optimize("O3")
#pragma GCC target("avx2")
#include <cstdio>
#include <algorithm>
#include <random>
#include <vector>

std::mt19937 rng;

const int N = 32005;
int n, a[N], cnt[N], b[N], aa[N];

void add(int i, int d) {
	while (i < n) {
		b[i] += d;
		i |= i + 1;
	}
}

int get(int i) {
	int s = 0;
	while (i >= 0) {
		s += b[i];
		i = (i & i + 1) - 1;
	}
	return s;
}

int calc(int l, int r) {
	int ans = 0;
	for (int i = l; i <= r; ++i) {
		int down = get(a[i] - 1);
		ans += down;
		ans -= i - l - down - cnt[a[i]];
		add(a[i], 1);
		++cnt[a[i]];
	}
	for (int i = l; i <= r; ++i) {
		add(a[i], -1);
		--cnt[a[i]];
	}
	return ans;
}

std::vector<std::pair<int, int> > ans;

void apply(int l, int r) {
	std::reverse(a + l, a + r + 1);
	ans.push_back(std::make_pair(l, r));
}

const int K = 1000;

bool cmp(std::pair<int, int> a, std::pair<int, int> b) {
	return a.second - a.first > b.second - b.first;
}

std::vector<std::pair<int, int> > seg;

void fill(int l, int r) {
	seg.push_back(std::make_pair(l, r - 1));
	if (r - l > 1) {
		fill(l, l + r >> 1);
		fill(l + r >> 1, r);
	}
}

int main() {
	scanf("%d", &n);
	for (int i = 0; i < n; ++i) scanf("%d", a + i);
	fill(0, n);
	std::sort(seg.begin(), seg.end(), cmp);
	for (int it = 0; it < seg.size(); ++it) {
		int l = seg[it].first, r = seg[it].second;
		if (l > r) std::swap(l, r);
		int val = -calc(l, r);
		if (val > (r - l + 1) * 4) {
			apply(l, r);
		}
	}
	for (int i = 0; i < n; ++i) aa[i] = a[i];
	std::sort(aa, aa + n);
	for (int i = 0; i < n; ++i) {
		int p;
		for (p = i; a[p] != aa[i]; ++p);
		if (i != p) apply(i, p);
	}
	printf("%d\n", (int)ans.size());
	for (int i = 0; i < (int)ans.size(); ++i) printf("%d %d\n", ans[i].first + 1, ans[i].second + 1);
	return 0;
}